/* Revenus du travail CN  partir des revenus fiscaux */
********************************************************


/* Points importants */
	* Pas de CSG exonr pour retraite et chom
	* Tout le monde cadre priv



clear
set more off

foreach pas of global yearliste {
	global year=`pas'

****************************************************************************************************************
* Importation des paramtres
	
	* Importation paramtres cotisations sociales et csg deduc
		use annee pss_a csg* crds*  s?prc*  p?prc* tx_cs* smic_m using  "$param/Parametres_cotisations.dta",clear
		rename annee year	
			* Transformation de tous les parametres en macrovariables */
				foreach var of varlist _all {
						quiet sum `var' if year==${year}
						global `var'=r(mean)
					}

	* Importation cotisations sociales salaris, non salaris, revenus non salairaux CN, revenus salariaux CN
		import excel using "$param/NationalAccountsparam.xlsx",first clear sheet("statarevtrav") cellrange(A7:M72) 
		* Transformation de tous les parametres en macrovariables */
			foreach var of varlist _all {
				quiet sum `var' if year==$year
				global `var'=r(mean)
			}
		
*******************************************************************************************************************
	
		use year idfoy idnum idindiv pondn ndecl conj pac age agec salchom_irpp_foy- pension_irpp_foy nonsal*  using "$wfrev/rev${year}.dta",clear
	
	

************************************
* I) Primary income				   *	
************************************

*I.A) Revenus salariaux 
	* Hyptohses : tout le monde secteur priv cadres	
	* Salaires supers-bruts = Salaires fiscaux + CSG dductibles + cotsoc sal ret, chom, non contri + cot soc pat ret, chom, non contri


	* I.A.1) Revenus bruts salariaux
		foreach var of newlist sal  {
			gen `var'_brut=0
			replace `var'_brut  =`var'_irpp/(1-${csg_act_ded}*(1-${csg_abt_0_4})-${s1prc})                                     
			replace `var'_brut  =(`var'_irpp+(${s1prc}-${s2prc})*${pss_a})/(1-${csg_act_ded}*(1-${csg_abt_0_4})-${s2prc}) if `var'_brut >=${pss_a}
			replace `var'_brut  =(`var'_irpp+(${s1prc}+3*${s2prc}-4*${s3prc}+4*(${csg_abt_4_}- ${csg_abt_0_4})*${csg_act_ded})*${pss_a})/(1-${csg_act_ded}*(1-${csg_abt_4_})-${s3prc}) if `var'_brut>=4*${pss_a} 
			replace `var'_brut  =(`var'_irpp+(${s1prc}+3*${s2prc}+4*${s3prc}-8*${s4prc}+4*(${csg_abt4_}-${csg_abt_0_4})*${csg_act_ded})*${pss_a})/(1-${csg_act_ded}*(1-${csg_abt_4_})-${s4prc}) if `var'_brut>=8*${pss_a} 
		
	* I.A.2) Calcul des cotisations sociales salariales
			foreach type in cho ret nco { 
				gen css`var'_`type'=0
				replace css`var'_`type'=${s1prc_`type'}*`var'_brut if `var'_brut <= ${pss_a} 
				replace css`var'_`type'=${s1prc_`type'}*${pss_a}+${s2prc_`type'}*(`var'_brut-${pss_a}) if `var'_brut>${pss_a} & `var'_brut<=4*${pss_a} 
				replace css`var'_`type'=${s1prc_`type'}*${pss_a}+${s2prc_`type'}*3*${pss_a}+${s3prc_`type'}*(`var'_brut-4*${pss_a}) if `var'_brut>4*${pss_a} & `var'_brut<=8*${pss_a} 
				replace css`var'_`type'=${s1prc_`type'}*${pss_a}+${s2prc_`type'}*3*${pss_a}+${s3prc_`type'}*4*${pss_a}+${s4prc_`type'}*(`var'_brut-8*${pss_a}) if `var'_brut>8*${pss_a} 
				}
				gen css`var' = css`var'_ret + css`var'_cho + css`var'_nco
				gen csg`var'=`var'_brut-css`var'-`var'_irpp
		
	* I.A.3) Calcul des cotisations sociales patronales 
			foreach type in cho ret nco { 
				gen csp`var'_`type'=0
				replace csp`var'_`type'=${p1prc_`type'}*`var'_brut if `var'_brut<${pss_a}
				replace csp`var'_`type'=${p1prc_`type'}*${pss_a}+${p2prc_`type'}*(`var'_brut-${pss_a}) if `var'_brut>=${pss_a} & `var'_brut<4*${pss_a} 
				replace csp`var'_`type'=${p1prc_`type'}*${pss_a}+${p2prc_`type'}*3*${pss_a}+${p3prc_`type'}*(`var'_brut-4*${pss_a}) if `var'_brut>=4*${pss_a} & `var'_brut<8*${pss_a}
				replace csp`var'_`type'=${p1prc_`type'}*${pss_a}+${p2prc_`type'}*3*${pss_a}+${p3prc_`type'}*4*${pss_a}+${p4prc_`type'}*(`var'_brut-8*${pss_a}) if `var'_brut>=8*${pss_a}
			}
			gen csp`var' = csp`var'_cho + csp`var'_ret + csp`var'_nco
			
	
		}
		*renvars sal_irpp_brut-cspsal_irpp, subst(_irpp ) 
		
	* I.A.4) Calcul des abattements de cotisations patronales sur les bas salaires
			* Note: Plusieurs systmes d'abattement ont t mis en place une mme anne; il s'agit ici d'une application approximative
			*       Les abattements 35h notamment ne sont pas dtaills.
			*       On utilise la formule des exonrations Fillon plutt que Aubry II 
			
			gen tx_exo =0
			gen csp_exo = 0
	
			* Exonration dgressive Jupp (1993-1999)
			* NB: entre 2000 et 2003, les exonrations Aubry I et Aubry II ont t appliques; mais trop complexes, impossibles  simuler! 

			replace tx_exo = ((0.55*(1.33*12*${smic_m} - sal_brut)))/sal_brut   if ${year}>=1993 & ${year}<=1997  & sal_brut > 12*${smic_m} &  sal_brut<=1.33*12*${smic_m}
			replace tx_exo = ((0.607*(1.3*12*${smic_m} - sal_brut)))/sal_brut	 if ${year}>=1998 & ${year}<=1999  & sal_brut > 12*${smic_m} &  sal_brut<=1.33*12*${smic_m}
			replace tx_exo = 0.182                                               if ${year}>=1996 & ${year}<=1999  & sal_brut <= 12*${smic_m}

			* Exonrations Fillon (2003- )
			replace tx_exo = (0.26)*min(1,max(1.6*(12*${smic_m}/sal_brut)-1,0)/0.6) if  ${year}>= 2000  

			replace csp_exo = tx_exo*sal_brut 
			replace csp_exo = min(csp_exo, ${smic_m}*12*0.182) 						if ${year}>=1993 & ${year}<=1999 
			* NB: le montant ${smic_m}*12*0.182 correspond au maximum de rduction pour un salari  temps plein.

		
	* I.A.5) Calage des revenus et des cotisations
			
			* Calage salaire brut
				* Avant calage en 2006: 646 milliards simuls contre 698 CN
				* Avant calage en 1993: 424 milliards simuls contre 428 CN
				gen temp= sal_brut 
				sum temp [aw=pondn]
				replace sal_brut=sal_brut*(${masse_salbrut_priv_cn}+${masse_salbrut_pub_cn})*1000000000/r(sum)
				drop temp
				
				
			* Calage cotisation sociales salariales
				* Avant calage en 2006: 87 milliards simuls contre 98 CN
				* Avant calage en 1993: 74.4 milliards simuls contre 75.64 CN
				gen temp= csssal 
				sum temp [aw=pondn]
				foreach var of varlist csssal csssal_nco csssal_ret csssal_cho {
					replace `var'=`var'*${masse_css_cn}*1000000000/r(sum)
				}
				drop temp
			
			* Calage exoneration de cotisation sociales patronales
					sum csp_exo [aw=pondn]
					replace csp_exo=csp_exo*${masse_csp_priv_exo}*1000000000/r(sum) if csp_exo~=0
				
			* Calage cotisations sociales patronales
				* Avant calage en 2006: 261 milliards simuls contre 269 CN
				* Avant calage en 1993: 167 milliards simuls contre 164 CN			
				gen temp= cspsal 
				sum temp [aw=pondn]
				foreach var of varlist cspsal_cho cspsal_ret cspsal_nco cspsal  {
					replace `var'=`var'*(${masse_csp_priv_cn}+${masse_csp_pub_cn}+${masse_csp_priv_exo})*1000000000/r(sum)
				}
				drop temp
			
				
		
	* I.A.6) Revenus salariaux superbruts  
		gen sal_FICN = sal_brut+cspsal- csp_exo
		

* I.B) revenus non salariaux 
		* revenus non salariaux super bruts = non sal irpp + CSG deduc + cotsoc contri, non contri

	foreach var of varlist nonsal   {
	
	* I.B.1) Revenus bruts non salariaux
			gen `var'_brut   = `var'_irpp/(1-${csg_act_ded}*(1-${csg_abt_0_4})-${tx_cs_nonsal_0})
			replace `var'_brut = (`var'_irpp+(${tx_cs_nonsal_0}-${tx_cs_nonsal_pss})*${pss_a})/(1-${csg_act_ded}*(1-${csg_abt_0_4})-${tx_cs_nonsal_pss})               if `var'_brut>=${pss_a} & `var'_brut>0
			replace `var'_brut = (`var'_irpp+(${tx_cs_nonsal_0}+3*${tx_cs_nonsal_pss}-4*${tx_cs_nonsal_4pss})*${pss_a})/(1-${csg_act_ded}*(1-${csg_abt_4_})-${tx_cs_nonsal_4pss})  if `var'_brut>=4*${pss_a} & `var'_brut>0
					
	* I.B.2) Calcul des cotisations sociales 		
			gen cs`var'_contr=0
			replace cs`var'_contr=${tx_cs_nonsal_contr_0}*`var'_brut if `var'_brut<=${pss_a} & `var'_brut>0
			replace cs`var'_contr=${tx_cs_nonsal_contr_0}*${pss_a}+${tx_cs_nonsal_contr_pss}*(`var'_brut-${pss_a}) if `var'_brut>${pss_a} & `var'_brut<=4*${pss_a} & `var'_brut>0
			replace cs`var'_contr=${tx_cs_nonsal_contr_0}*${pss_a}+${tx_cs_nonsal_contr_pss}*3*${pss_a}+${tx_cs_nonsal_contr_4pss}*(`var'_brut-4*${pss_a}) if `var'_brut>4*${pss_a} & `var'_brut>0 
			
			gen cs`var'_noncontr=0
			replace cs`var'_noncontr=${tx_cs_nonsal_noncontr_0}*`var'_brut if `var'_brut<=${pss_a} & `var'_brut>0
			replace cs`var'_noncontr=${tx_cs_nonsal_noncontr_0}*${pss_a}+${tx_cs_nonsal_noncontr_pss}*(`var'_brut-${pss_a}) if `var'_brut>${pss_a} & `var'_brut<=4*${pss_a} & `var'_brut>0
			replace cs`var'_noncontr=${tx_cs_nonsal_noncontr_0}*${pss_a}+${tx_cs_nonsal_noncontr_pss}*3*${pss_a}+${tx_cs_nonsal_noncontr_4pss}*(`var'_brut-4*${pss_a}) if `var'_brut>4*${pss_a} & `var'_brut>0 

			gen cs`var'=	cs`var'_contr+cs`var'_noncontr	
		}
			*renvars nonsal_irpp_brut-csnonsal_irpp, subst(_irpp ) 

	* I.B.3) Calage des revenus et des cotisations
		
		* Calage des revenus non salariaux bruts
			* Avant calage en 2006: 82 milliards simuls contre 105 CN
			gen temp= nonsal_brut
			sum temp [aw=pondn]
			replace nonsal_brut=(nonsal_brut)*${masse_nonsalbrut_cn}*1000000000/r(sum)
			drop temp
			
		* Calage des cotisations
			* Avant calage en 2006: 20 milliards simuls contre 23 CN
			gen temp= csnonsal 
			sum temp [aw=pondn]
			foreach var of varlist csnonsal_contr-csnonsal {
				replace `var'=`var'*${masse_cs_nonsal_cn}*1000000000/r(sum)
			}
			drop temp
		
					
	* I.B.4) Revenus non-salariaux bruts 
		gen nonsal_FICN = nonsal_brut
		gen nonsal_capital_cn = 0.3*nonsal_FICN
		gen nonsal_labor_FICN = 0.7*nonsal_FICN

			
			
************************************
* II) Pre-Tax income				   *	
************************************	


	* On ajoute les pensions et les allocations chomages dans les revenus du travail
	* On compense cet ajout en enlevant l'ensemble des cotisations sociales
	

* II.A) Retraites et chomage
		* pension = pension irpp+ CSG deduc 
		* chomage = chomage irpp+csg deduc
		* Pour le moment, pas d'exoneration de csg
		foreach var of newlist pension   {
			gen `var'_brut=`var'_irpp/(1-${csg_pens_ded} )   
		}
		foreach var of newlist chom   {
			gen `var'_brut=`var'_irpp/(1-${csg_cho_ded}*(1-${csg_abt_0_4}))
			replace `var'_brut  =(`var'_irpp+4*(${csg_abt_4_}- ${csg_abt_0_4})*${csg_cho_ded}*${pss_a})/(1-${csg_act_ded}*(1-${csg_abt_4_})) if `var'_brut>=4*${pss_a} 
		}
		* Calage des pensions et des allocs chom
			gen temp=pension_brut+chom_brut
			sum temp [aw=pondn]
			foreach var of varlist pension_brut chom_brut  {
				replace `var'=`var'*${masse_pension_cn}*1000000000/r(sum)
			}
			drop temp
			
		*renvars pension_irpp_brut-chom_irpp_brut, subst(_irpp ) 

		
* II.B) Calcul des Pre-tax income
			* Pour les revenus salariaux, on enlve les cotisations 
			gen sal_pretaxCN = sal_FICN - csssal -(cspsal- csp_exo)  
			
			* Pour les revenus non salariaux, seule la partie labor se voit imputer les cotisations contributives
			gen nonsal_pretaxCN = nonsal_FICN-csnonsal
			gen nonsal_labor_pretaxCN = nonsal_labor_FICN-csnonsal 

			gen pension_pretaxCN=pension_brut
			gen chom_pretaxCN= chom_brut
			
				
			
*************************************************
* III) Retraitement des revenus non salariaux	*
*************************************************			
	* Labor component individualis
	* capital component identique pour les membres d'un couple et nul pour les pac
		bys idfoy: egen temp=sum(nonsal_capital_cn)
		replace nonsal_capital_cn=temp/ndecl if pac==0
		replace nonsal_capital_cn=0 if pac==1
		drop temp
		
		foreach var of newlist FICN pretaxCN  {
			replace nonsal_`var'=nonsal_capital_cn + nonsal_labor_`var'
			
		}
		gen rtrav_FICN= sal_FICN + nonsal_labor_FICN	
		gen rtrav_pretaxCN=sal_pretaxCN +nonsal_labor_pretaxCN + pension_pretaxCN+ chom_pretaxCN
	
*****************************************
* IV) Income before Production taxes 	*
*****************************************

* Pour coller au revenu national, on ralloue les impts sur la productions (hors taxe foncire mnage) au prorata de l'ensemble des revenus (travail et capital)
* Voir onglet Table A10 to A13 de AppendixNationalAccounts pour plus de dtails
	foreach var of varlist  rtrav_FICN sal_FICN  nonsal_labor_FICN nonsal_FICN   {
			replace `var'=`var'*${productaxfactor}
	}
	foreach var of varlist  rtrav_pretaxCN sal_pretaxCN  nonsal_labor_pretaxCN  pension_pretaxCN chom_pretaxCN  nonsal_pretaxCN nonsal_capital_cn   {
			replace `var'=`var'*${productaxpretax}
	}
	
	
	
keep year idfoy idnum idindiv pondn ndecl rtrav_FICN rtrav_pretaxCN sal_FICN nonsal_FICN nonsal_capital_cn nonsal_labor_FICN sal_pretaxCN nonsal_pretaxCN nonsal_labor_pretaxCN pension_pretaxCN chom_pretaxCN
	#delimit;
			order year idfoy idnum idindiv pondn ndecl    
			rtrav_FICN sal_FICN  nonsal_labor_FICN 
			rtrav_pretaxCN sal_pretaxCN  nonsal_labor_pretaxCN  pension_pretaxCN chom_pretaxCN 
			nonsal_FICN nonsal_pretaxCN nonsal_capital_cn;
	#delimit cr
	
	
		save "$wfrevtravcn/revtravcn${year}.dta",replace	
	
	macro drop pss_a csg* crds*  s1prc* s2prc* s3prc* s4prc*  p1prc* p2prc* p3prc* p4prc* tx_cs* smic_m masse* productaxfactor productaxpretax

}	
			
		
		
***********************************************************************************************		

	
